/** @file   eng2d_Exception.cpp
 * @brief   Implementation of the exception classes in eng2d-library.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "eng2d_Exception.h"
using std::string;

namespace eng2d {


///
/// Static members, constants and datatypes
/// =======================================




///
/// The exception baseclass.
/// ========================


/** Constructor
 */
xBaseException::xBaseException() :
  iClassName( "not available" ),
  iMethodName( "not available" ),
  iMessage( "not available" )
{
}




/** Constructor
 */
xBaseException::xBaseException( const string& aMessage ) :
  iClassName( "not available" ),
  iMethodName( "not available" ),
  iMessage( aMessage )
{
}



/** Constructor
 */
xBaseException::xBaseException( const string& aClassName,
                                const string& aMethodName,
                                const std::string& aMessage ) :
  iClassName( aClassName ),
  iMethodName( aMethodName ),
  iMessage( aMessage )
{
}


  
/** Destructor
 */
xBaseException::~xBaseException()
{
}



/** Copy constructor
 */
xBaseException::xBaseException( const xBaseException& aObj ) :
  iClassName( aObj.iClassName ),
  iMethodName( aObj.iMethodName ),
  iMessage( aObj.iMessage )
{
}



/** An assignment operator
 */
xBaseException& xBaseException::operator = ( const xBaseException& aObj )
{
  if ( this != &aObj ) {
    iClassName = aObj.iClassName;
    iMethodName = aObj.iMethodName;
    iMessage = aObj.iMessage;
  }
  return *this;
}






///
/// Out of bounds exception
/// =======================

/** Constructor.
 */
xOutOfBounds::xOutOfBounds() :
  xBaseException()
{
}



/** Constructor
 */
xOutOfBounds::xOutOfBounds( const string& aClassName,
                            const string& aMethodName ) :
  xBaseException( aClassName, aMethodName, "out of bounds" )
{
}



/** Destructor.
 */
xOutOfBounds::~xOutOfBounds()
{
}



/** Copy constructor
 */
xOutOfBounds::xOutOfBounds( const xOutOfBounds& aObj ) :
  xBaseException( aObj )
{
}



/** Assignment operator
 */
xOutOfBounds& xOutOfBounds::operator = ( const xOutOfBounds& aObj )
{
  if ( this != &aObj ) {
    xBaseException::operator = ( aObj );
  }
  return *this;
}




///
/// xLogicError exception
/// =====================

/** Constructor.
 */
xLogicError::xLogicError() :
  xBaseException()
{
}



/** Constructor.
 */
xLogicError::xLogicError( const string& aClassName,
                          const string& aMethodName,
                          const string& aMessage ) :
  xBaseException( aClassName, aMethodName, aMessage )
{
}



/** Copy constructor.
 */
xLogicError::xLogicError( const xLogicError& aObj ) :
  xBaseException( aObj )
{
}



/** Destructor.
 */
xLogicError::~xLogicError()
{
}



/** An assignment operator.
 */
xLogicError& xLogicError::operator = ( const xLogicError& aObj )
{
  if ( this != &aObj ) {
    xBaseException::operator = ( aObj );
  }
  return *this;
}



///
/// xRuntimeError exception
/// =======================

/** Constructor.
 */
xRuntimeError::xRuntimeError() :
  xBaseException()
{
}



/** Constructor.
 */
xRuntimeError::xRuntimeError( const string& aClassName,
                              const string& aMethodName,
                              const string& aMessage ) :
  xBaseException( aClassName, aMethodName, aMessage )
{
}



/** Copy constructor.
 */
xRuntimeError::xRuntimeError( const xRuntimeError& aObj ) :
  xBaseException( aObj )
{
}



/** Destructor.
 */
xRuntimeError::~xRuntimeError()
{
}



/** An assignment operator.
 */
xRuntimeError& xRuntimeError::operator = ( const xRuntimeError& aObj )
{
  if ( this != &aObj ) {
    xBaseException::operator = ( aObj );
  }
  return *this;
}



///
/// xIoError exception
/// =======================

/** Constructor.
 */
xIoError::xIoError() :
  xBaseException()
{
}



/** Constructor.
 */
xIoError::xIoError( const string& aClassName,
                              const string& aMethodName,
                              const string& aMessage ) :
  xBaseException( aClassName, aMethodName, aMessage )
{
}



/** Copy constructor.
 */
xIoError::xIoError( const xIoError& aObj ) :
  xBaseException( aObj )
{
}



/** Destructor.
 */
xIoError::~xIoError()
{
}



/** An assignment operator.
 */
xIoError& xIoError::operator = ( const xIoError& aObj )
{
  if ( this != &aObj ) {
    xBaseException::operator = ( aObj );
  }
  return *this;
}

} // end of namespace
